/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/




// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_basegfx.hxx"
// autogenerated file with codegen.pl

#include "preextstl.h"
#include "cppunit/TestAssert.h"
#include "cppunit/TestFixture.h"
#include "cppunit/extensions/HelperMacros.h"
#include "postextstl.h"

#include <basegfx/matrix/b2dhommatrix.hxx>
#include <basegfx/curve/b2dcubicbezier.hxx>
#include <basegfx/curve/b2dbeziertools.hxx>
#include <basegfx/range/b2dpolyrange.hxx>
#include <basegfx/polygon/b2dpolygon.hxx>
#include <basegfx/polygon/b2dpolygontools.hxx>
#include <basegfx/polygon/b2dpolypolygontools.hxx>
#include <basegfx/polygon/b2dpolypolygoncutter.hxx>
#include <basegfx/polygon/b2dpolygonclipper.hxx>
#include <basegfx/polygon/b2dpolypolygon.hxx>
#include <basegfx/numeric/ftools.hxx>

#include <boost/bind.hpp>

using namespace ::basegfx;


namespace basegfx2d
{

class genericclipper : public CppUnit::TestFixture
{
private:
    B2DPolygon aSelfIntersecting;
    B2DPolygon aShiftedRectangle;

public:
    // initialise your test code values here.
    void setUp()
    {
        aSelfIntersecting.append(B2DPoint(0,  0));
        aSelfIntersecting.append(B2DPoint(0,  100));
        aSelfIntersecting.append(B2DPoint(75, 100));
        aSelfIntersecting.append(B2DPoint(75, 50));
        aSelfIntersecting.append(B2DPoint(25, 50));
        aSelfIntersecting.append(B2DPoint(25, 150));
        aSelfIntersecting.append(B2DPoint(100,150));
        aSelfIntersecting.append(B2DPoint(100,0));
        aSelfIntersecting.setClosed(true);

        aShiftedRectangle = tools::createPolygonFromRect(
            B2DRange(0,90,20,150));
    }

    void tearDown()
    {}

    void validate(const char* pName, 
                  const char* pValidSvgD, 
                  B2DPolyPolygon (*pFunc)(const B2DPolyPolygon&, const B2DPolyPolygon&))
    {
        const B2DPolyPolygon aSelfIntersect(
            tools::prepareForPolygonOperation(aSelfIntersecting));
        const B2DPolyPolygon aRect(
            tools::prepareForPolygonOperation(aShiftedRectangle));
#if defined(VERBOSE)
        fprintf(stderr, "%s input LHS - svg:d=\"%s\"\n", 
                pName, rtl::OUStringToOString(
                    basegfx::tools::exportToSvgD(
                        aSelfIntersect, true, true, false),
                    RTL_TEXTENCODING_UTF8).getStr() );
        fprintf(stderr, "%s input RHS - svg:d=\"%s\"\n", 
                pName, rtl::OUStringToOString(
                    basegfx::tools::exportToSvgD(
                        aRect, true, true, false),
                    RTL_TEXTENCODING_UTF8).getStr() );
#endif

        const B2DPolyPolygon aRes=
            pFunc(aSelfIntersect, aRect);

#if defined(VERBOSE)
        fprintf(stderr, "%s - svg:d=\"%s\"\n", 
                pName, rtl::OUStringToOString(
                    basegfx::tools::exportToSvgD(aRes, true, true, false),
                    RTL_TEXTENCODING_UTF8).getStr() );
#endif

        rtl::OUString aValid=rtl::OUString::createFromAscii(pValidSvgD);

        CPPUNIT_ASSERT_MESSAGE(pName,
                               basegfx::tools::exportToSvgD(aRes, true, true, false) == aValid);
    }

    void validateOr()
    {
        const char* pValid="m0 0h100v150h-75v-50h-5v50h-20v-50-10zm75 10v-50h-50v50z";
        validate("validateOr", pValid, &tools::solvePolygonOperationOr);
    }

    void validateXor()
    {
        const char* pValid="m0 0h100v150h-75v-50h-5v50h-20v-50-10zm0 10h20v-10h-20zm75 10v-50h-50v50z";
        validate("validateXor", pValid, &tools::solvePolygonOperationXor);
    }

    void validateAnd()
    {
        const char* pValid="m0 100v-10h20v10z";
        validate("validateAnd", pValid, &tools::solvePolygonOperationAnd);
    }

    void validateDiff()
    {
        const char* pValid="m0 90v-90h100v150h-75v-50h-5v-10zm55 10v-50h-50v50z";
        validate("validateDiff", pValid, &tools::solvePolygonOperationDiff);
    }

    // Change the following lines only, if you add, remove or rename 
    // member functions of the current class, 
    // because these macros are need by auto register mechanism.

    CPPUNIT_TEST_SUITE(genericclipper);
    CPPUNIT_TEST(validateOr);
    CPPUNIT_TEST(validateXor);
    CPPUNIT_TEST(validateAnd);
    CPPUNIT_TEST(validateDiff);
    CPPUNIT_TEST_SUITE_END();
};

// -----------------------------------------------------------------------------
CPPUNIT_TEST_SUITE_REGISTRATION(basegfx2d::genericclipper);
} // namespace basegfx2d
