/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef ADC_UIDL_TK_IDENT_HXX
#define ADC_UIDL_TK_IDENT_HXX

// USED SERVICES
	// BASE CLASSES
#include <s2_luidl/uidl_tok.hxx>
	// COMPONENTS
	// PARAMETERS


namespace csi
{
namespace uidl
{


class TokIdentifier : public Token
{
  public:
						TokIdentifier(
							const char *		i_sText )
												:	sText(i_sText) {}

	virtual void		Trigger(
							TokenInterpreter &	io_rInterpreter ) const;
	virtual const char *
						Text() const;
  private:
	// DATA
	String 				sText;
};

class TokNameSeparator : public Token
{
  public:
	virtual void		Trigger(
							TokenInterpreter &	io_rInterpreter ) const;
	virtual const char *
						Text() const;
};


}   // namespace uidl
}   // namespace csi

#endif


