/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef ARY_IDL_I_PARAM_HXX
#define ARY_IDL_I_PARAM_HXX

// BASE CLASSES
#include <ary/idl/i_types4idl.hxx>




namespace ary
{
namespace idl
{


/** Represents a parameter in an IDL function.
*/
class Parameter
{
  public:
    // LIFECYCLE
                        Parameter(
                            const String &      i_sName,
                            Type_id             i_nType,
                            E_ParameterDirection
                                                i_eDirection );
                        ~Parameter();

    // INQUIRY
    const String &      Name() const            { return sName; }
    Type_id             Type() const            { return nType; }
    E_ParameterDirection
                        Direction() const       { return eDirection; }

  private:
    // DATA
    String              sName;
    Type_id             nType;
    E_ParameterDirection
                        eDirection;
};




}   // namespace idl
}   // namespace ary
#endif
