/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef ARY_CPP_C_TYDEF_HXX
#define ARY_CPP_C_TYDEF_HXX



// USED SERVICES
	// BASE CLASSES
#include <ary/cpp/c_ce.hxx>
	// OTHER
#include <ary/cessentl.hxx>
#include <ary/cpp/c_types4cpp.hxx>



namespace ary
{
namespace cpp
{


/** A C++ typedef declaration.
*/
class Typedef : public CodeEntity
{
  public:
    // LIFECYCLE
    enum E_ClassId { class_id = 1003 };

                        Typedef(
                            const String  &     i_sLocalName,
                            Ce_id               i_nOwner,
                            E_Protection        i_eProtection,
                            Lid                 i_nFile,
                            Type_id             i_nDescribingType );
                        ~Typedef();
    // INQUIRY
	Type_id             DescribingType() const;
	E_Protection        Protection() const      { return eProtection; }

  private:
    // Interface csv::ConstProcessorClient
    virtual void        do_Accept(
                            csv::ProcessorIfc & io_processor ) const;

    // Interface ary::cpp::CodeEntity
	virtual const String  &
                        inq_LocalName() const;
	virtual Cid         inq_Owner() const;
	virtual Lid			inq_Location() const;

    // Interface ary::cpp::CppEntity
    virtual ClassId     get_AryClass() const;

    // DATA
	CeEssentials		aEssentials;
	Type_id             nDescribingType;
	E_Protection		eProtection;
};



// IMPLEMENTATION
inline Type_id
Typedef::DescribingType() const
{
    return nDescribingType;
}



}   //  namespace cpp
}   //  namespace ary
#endif
