/**************************************************************
 * 
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * 
 *************************************************************/



#ifndef INCLUDED_ANIMATIONS_ANIMATIONNODEHELPER_HXX
#define INCLUDED_ANIMATIONS_ANIMATIONNODEHELPER_HXX

#include <com/sun/star/uno/Reference.hxx>
#include <com/sun/star/animations/XAnimationNode.hpp>
#include <com/sun/star/container/XEnumerationAccess.hpp>
#include <com/sun/star/container/XEnumeration.hpp>

#include <vector>

/* Declaration and definition of AnimationNode helper */

namespace anim
{
    // TODO(Q1): this could possibly be implemented with a somewhat
    // more lightweight template, by having the actual worker receive
    // only a function pointer, and a thin templated wrapper around
    // that which converts member functions into that.

    /** Apply given functor to every animation node child.

	    @param xNode 
        Parent node

        @param rFunctor
        Functor to apply. The functor must have an appropriate
        operator()( const ::com::sun::star::uno::Reference<
        ::com::sun::star::animations::XAnimationNode >& ) member.

        @return true, if the functor was successfully applied to
        all children, false otherwise.
    */
    template< typename Functor > inline bool for_each_childNode( const ::com::sun::star::uno::Reference< ::com::sun::star::animations::XAnimationNode >&	xNode,
                                                          Functor&																					rFunctor )
    {
        try
        {
            // get an XEnumerationAccess to the children
            ::com::sun::star::uno::Reference< ::com::sun::star::container::XEnumerationAccess > 
                  xEnumerationAccess( xNode, 
                                      ::com::sun::star::uno::UNO_QUERY_THROW );
            ::com::sun::star::uno::Reference< ::com::sun::star::container::XEnumeration > 
                  xEnumeration( xEnumerationAccess->createEnumeration(), 
                                ::com::sun::star::uno::UNO_QUERY_THROW );
                
            while( xEnumeration->hasMoreElements() )
            {
                ::com::sun::star::uno::Reference< ::com::sun::star::animations::XAnimationNode > 
                      xChildNode( xEnumeration->nextElement(), 
                                  ::com::sun::star::uno::UNO_QUERY_THROW );

                rFunctor( xChildNode );
            }

            return true;
        }
        catch( ::com::sun::star::uno::Exception& )
        {
            return false;
        }
    }


	/** pushes the given node to the given vector and recursivly calls itself for each child node.
	*/
	inline void create_deep_vector( const ::com::sun::star::uno::Reference< ::com::sun::star::animations::XAnimationNode >& xNode,
								std::vector< ::com::sun::star::uno::Reference< ::com::sun::star::animations::XAnimationNode > >& rVector )
	{
		rVector.push_back( xNode );

        try
        {
            // get an XEnumerationAccess to the children
            ::com::sun::star::uno::Reference< ::com::sun::star::container::XEnumerationAccess > 
                  xEnumerationAccess( xNode, 
                                      ::com::sun::star::uno::UNO_QUERY );

			if( xEnumerationAccess.is() )
			{
				::com::sun::star::uno::Reference< ::com::sun::star::container::XEnumeration > 
		              xEnumeration( xEnumerationAccess->createEnumeration(), 
			                        ::com::sun::star::uno::UNO_QUERY );
                
				if( xEnumeration.is() )
				{
					while( xEnumeration->hasMoreElements() )
					{
						::com::sun::star::uno::Reference< ::com::sun::star::animations::XAnimationNode > 
							xChildNode( xEnumeration->nextElement(), 
										::com::sun::star::uno::UNO_QUERY_THROW );

						create_deep_vector( xChildNode, rVector );
					}
				}
			}
        }
        catch( ::com::sun::star::uno::Exception& )
        {
        }
	}
}

#endif /* INCLUDED_ANIMATIONS_ANIMATIONNODEHELPER_HXX */
